/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino;

import dev.latvian.mods.rhino.ClassShutter;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.JavaAdapter;
import dev.latvian.mods.rhino.JavaMembers;
import dev.latvian.mods.rhino.NativeJavaClass;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.ScriptableObject;
import dev.latvian.mods.rhino.WrapFactory;
import dev.latvian.mods.rhino.classdata.ClassDataCache;
import dev.latvian.mods.rhino.util.CustomJavaToJsWrapper;
import dev.latvian.mods.rhino.util.CustomJavaToJsWrapperProvider;
import dev.latvian.mods.rhino.util.CustomJavaToJsWrapperProviderHolder;
import dev.latvian.mods.rhino.util.DefaultRemapper;
import dev.latvian.mods.rhino.util.Remapper;
import dev.latvian.mods.rhino.util.wrap.TypeWrappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class SharedContextData {
    public static final Object AKEY = "ClassCache";
    public final Scriptable topLevelScope;
    final List<CustomJavaToJsWrapperProviderHolder<?>> customScriptableWrappers = new ArrayList();
    final Map<Class<?>, CustomJavaToJsWrapperProvider> customScriptableWrapperCache = new HashMap();
    private final Map<String, Object> extraProperties = new HashMap<String, Object>();
    TypeWrappers typeWrappers;
    Remapper remapper = DefaultRemapper.INSTANCE;
    private transient Map<Class<?>, JavaMembers> classTable;
    private transient Map<JavaAdapter.JavaAdapterSignature, Class<?>> classAdapterCache;
    private transient Map<Class<?>, Object> interfaceAdapterCache;
    private int generatedClassSerial;
    private ClassDataCache classDataCache;
    private ClassShutter classShutter;
    private WrapFactory wrapFactory;

    public static SharedContextData get(Scriptable scope) {
        SharedContextData cache = (SharedContextData)ScriptableObject.getTopScopeValue(scope, AKEY);
        if (cache == null) {
            throw new RuntimeException("Can't find top level scope for SharedContextData.get");
        }
        return cache;
    }

    public static SharedContextData get(Context cx, Scriptable scope) {
        return cx.sharedContextData != null ? cx.sharedContextData : SharedContextData.get(scope);
    }

    public SharedContextData(Scriptable scope) {
        this.topLevelScope = scope;
    }

    Map<Class<?>, JavaMembers> getClassCacheMap() {
        if (this.classTable == null) {
            this.classTable = new ConcurrentHashMap(16, 0.75f, 1);
        }
        return this.classTable;
    }

    Map<JavaAdapter.JavaAdapterSignature, Class<?>> getInterfaceAdapterCacheMap() {
        if (this.classAdapterCache == null) {
            this.classAdapterCache = new ConcurrentHashMap(16, 0.75f, 1);
        }
        return this.classAdapterCache;
    }

    public final synchronized int newClassSerialNumber() {
        return ++this.generatedClassSerial;
    }

    Object getInterfaceAdapter(Class<?> cl) {
        return this.interfaceAdapterCache == null ? null : this.interfaceAdapterCache.get(cl);
    }

    synchronized void cacheInterfaceAdapter(Class<?> cl, Object iadapter) {
        if (this.interfaceAdapterCache == null) {
            this.interfaceAdapterCache = new ConcurrentHashMap(16, 0.75f, 1);
        }
        this.interfaceAdapterCache.put(cl, iadapter);
    }

    public TypeWrappers getTypeWrappers() {
        if (this.typeWrappers == null) {
            this.typeWrappers = new TypeWrappers();
        }
        return this.typeWrappers;
    }

    public boolean hasTypeWrappers() {
        return this.typeWrappers != null;
    }

    public Remapper getRemapper() {
        return this.remapper;
    }

    public void setRemapper(Remapper remapper) {
        this.remapper = remapper;
    }

    public ClassDataCache getClassDataCache() {
        if (this.classDataCache == null) {
            this.classDataCache = new ClassDataCache(this);
        }
        return this.classDataCache;
    }

    @Nullable
    public CustomJavaToJsWrapper wrapCustomJavaToJs(Object javaObject) {
        if (this.customScriptableWrappers.isEmpty()) {
            return null;
        }
        CustomJavaToJsWrapperProvider<Object> provider = this.customScriptableWrapperCache.get(javaObject.getClass());
        if (provider == null) {
            CustomJavaToJsWrapperProviderHolder<?> wrapper;
            Iterator<CustomJavaToJsWrapperProviderHolder<?>> iterator = this.customScriptableWrappers.iterator();
            while (iterator.hasNext() && (provider = (wrapper = iterator.next()).create(javaObject)) == null) {
            }
            if (provider == null) {
                provider = CustomJavaToJsWrapperProvider.NONE;
            }
            this.customScriptableWrapperCache.put(javaObject.getClass(), provider);
        }
        return provider.create(javaObject);
    }

    public <T> void addCustomJavaToJsWrapper(Predicate<T> predicate, CustomJavaToJsWrapperProvider<T> provider) {
        this.customScriptableWrappers.add(new CustomJavaToJsWrapperProviderHolder<T>(predicate, provider));
    }

    public <T> void addCustomJavaToJsWrapper(Class<T> type, CustomJavaToJsWrapperProvider<T> provider) {
        this.addCustomJavaToJsWrapper(new CustomJavaToJsWrapperProviderHolder.PredicateFromClass<T>(type), provider);
    }

    public void setExtraProperty(String key, @Nullable Object value) {
        if (value == null) {
            this.extraProperties.remove(key);
        } else {
            this.extraProperties.put(key, value);
        }
    }

    @Nullable
    public Object getExtraProperty(String key) {
        return this.extraProperties.get(key);
    }

    @Nullable
    public final synchronized ClassShutter getClassShutter() {
        return this.classShutter;
    }

    public final synchronized void setClassShutter(ClassShutter shutter) {
        if (shutter == null) {
            throw new IllegalArgumentException();
        }
        if (this.classShutter != null) {
            throw new SecurityException("Cannot overwrite existing ClassShutter object");
        }
        this.classShutter = shutter;
    }

    public void addToTopLevelScope(String name, Object value) {
        if (value instanceof Class) {
            Class c = (Class)value;
            ScriptableObject.putProperty(this.topLevelScope, name, (Object)new NativeJavaClass(this.topLevelScope, c));
        } else {
            ScriptableObject.putProperty(this.topLevelScope, name, Context.javaToJS(this, value, this.topLevelScope));
        }
    }

    public final WrapFactory getWrapFactory() {
        if (this.wrapFactory == null) {
            this.wrapFactory = new WrapFactory();
        }
        return this.wrapFactory;
    }

    public final void setWrapFactory(WrapFactory wrapFactory) {
        if (wrapFactory == null) {
            throw new IllegalArgumentException();
        }
        this.wrapFactory = wrapFactory;
    }
}

